using System;
using System.Data;
using System.Data.SqlClient;
using System.Reflection;
using gov.va.med.vbecs.ExceptionManagement;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARITIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.DAL
{
		#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>John Vrooland</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>1/31/2003</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///	The class implements data persistence logic for workload-related data. 
	///	It exposes methods allowing retrieval and updates for workload-related info.
	///</summary>

		#endregion

	public class WorkLoad
	{

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/31/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1558"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1324"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Retrieve all the workload processes.
		/// </summary>
		/// <returns>DataTable with process namespace and ID</returns>
		public static DataTable GetAllVbecsProcesses()
		{
			DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.GetAllVbecsProcesses.StoredProcName);
			
			return ds.Tables[0];
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/31/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1559"> 
		///		<ExpectedInput>Valid Division Code</ExpectedInput>
		///		<ExpectedOutput>DataTable of workload processes</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1977"> 
		///		<ExpectedInput>invalid Division</ExpectedInput>
		///		<ExpectedOutput>Empty Datatable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Get all defined workload-process associations for a division.
		/// </summary>
		/// <param name="divisionCode">Division code</param>
		/// <returns>DataTable containing the workload data</returns>
		public static DataTable GetVbecsWorkLoadForDivision(string divisionCode)
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetVbecsWorkLoadForDivision.divisioncode, System.Data.SqlDbType.VarChar)
			};
			
			prms[0].Value = divisionCode;
			
			DataSet	ds = Common.StoredProcedure.GetData(STOREDPROC.GetVbecsWorkLoadForDivision.StoredProcName, prms);
			
			// ds.Tables[0].Columns.Add(ARITIFICIAL.Procedure, typeof(string));
			ds.Tables[0].Columns.Add(ARITIFICIAL.Process, typeof(string));
			ds.Tables[0].Columns.Add(ARITIFICIAL.Cost, typeof(decimal));
			ds.Tables[0].Columns[TABLE.WorkloadProcess.AssignedDate].ReadOnly = false;
			ds.Tables[0].Columns[TABLE.WorkloadProcess.UnAssignedDate].ReadOnly = false;
			ds.Tables[0].Columns[TABLE.WorkloadProcess.LastUpdateDate].ReadOnly = false;
		
			return ds.Tables[0];
		}

		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/31/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1560"> 
		///		<ExpectedInput>Valid DataTable</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1981"> 
		///		<ExpectedInput>Bad RowVersion</ExpectedInput>
		///		<ExpectedOutput>RowVersionException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Saves the changes to the workload data.
		/// </summary>
		/// <param name="dt">DataTable containing modified and added values</param>
		/// <param name="lastUpdateFunctionId">UC or calling method</param>
		public static void SaveWorkLoadChanges(DataTable dt, Common.UpdateFunction lastUpdateFunctionId)
		{
			System.Collections.ArrayList _dtArrayList = new System.Collections.ArrayList();
			System.Collections.ArrayList _sprocArrayList = new System.Collections.ArrayList();
			StoredProcedure sproc = new StoredProcedure();
			int returnValue = 0;

			DataTable dtTmp1 = dt.GetChanges(DataRowState.Modified);
			if (dtTmp1 != null)
			{
				DataTable dtUpdates = dt.GetChanges(DataRowState.Modified).Copy();
				DataTable tmpUpdate = DAL.WorkLoad.GetEmptyWorkloadProcessTableSchema(true);

				// Build a copy of the data we're going to update
				foreach(DataRow drUpd in dtUpdates.Rows)
				{
					DataRow drTmp = tmpUpdate.NewRow();
					foreach(DataColumn dc in dtUpdates.Columns)
					{
						if(tmpUpdate.Columns.Contains(dc.ColumnName))
							drTmp[dc.ColumnName] = drUpd[dc.ColumnName];
					}
					tmpUpdate.Rows.Add(drTmp);
				}
				_dtArrayList.Add(Common.Utility.AppendLastUpdateInformation(tmpUpdate, lastUpdateFunctionId));
				_sprocArrayList.Add(Common.VbecsStoredProcs.UpdateWorkLoadProcess.StoredProcName);
			}

			DataTable dtTmp2 = dt.GetChanges(DataRowState.Added);
			if (dtTmp2 != null)
			{
				DataTable dtInserts = dt.GetChanges(DataRowState.Added).Copy();
				DataTable tmpInsert = DAL.WorkLoad.GetEmptyWorkloadProcessTableSchema(false);

				// Build a copy of the data we're going to insert
				foreach(DataRow drIns in dtInserts.Rows)
				{
					DataRow drTmp = tmpInsert.NewRow();
					foreach(DataColumn dc in dtInserts.Columns)
					{
						if(tmpInsert.Columns.Contains(dc.ColumnName))
							drTmp[dc.ColumnName] = drIns[dc.ColumnName];
					}
					tmpInsert.Rows.Add(drTmp);
				}

				_dtArrayList.Add(Common.Utility.AppendLastUpdateInformation(tmpInsert, lastUpdateFunctionId));
				_sprocArrayList.Add(Common.VbecsStoredProcs.InsertWorkLoadProcess.StoredProcName);
			}

			returnValue = sproc.TransactionalGetValue(_sprocArrayList,_dtArrayList);
		}


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/19/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8053"> 
		///		<ExpectedInput>true</ExpectedInput>
		///		<ExpectedOutput>DataTable with RowVersion</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8054"> 
		///		<ExpectedInput>false</ExpectedInput>
		///		<ExpectedOutput>DataTable without RowVersion</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// spInsertWorkloadProcess, spUpdateworkloadProcess
		/// </summary>
		/// <param name="isUpdate"></param>
		/// <returns></returns>
		public static DataTable GetEmptyWorkloadProcessTableSchema(bool isUpdate)
		{
			DataTable dtEmpty = new DataTable(TABLE.WorkloadProcess.TableName);

			dtEmpty.Columns.Add(TABLE.WorkloadProcess.WorkloadProcessGuid, typeof(System.Guid));
			dtEmpty.Columns.Add(TABLE.WorkloadProcess.WeightMultiplier, typeof(int));
			dtEmpty.Columns.Add(TABLE.WorkloadProcess.AssignedDate, typeof(System.DateTime));
			dtEmpty.Columns.Add(TABLE.WorkloadProcess.UnAssignedDate, typeof(System.DateTime));
			dtEmpty.Columns.Add(TABLE.WorkloadProcess.DivisionCode, typeof(string));
			dtEmpty.Columns.Add(TABLE.WorkloadProcess.RecordStatusCode, typeof(string));

			if (isUpdate)
			{
				dtEmpty.Columns.Add(TABLE.WorkloadProcess.RowVersion, typeof(byte[]));
			}
			else
			{
				dtEmpty.Columns.Add(TABLE.WorkloadProcess.WorkloadCode, typeof(string));
				dtEmpty.Columns.Add(TABLE.WorkloadProcess.WorkloadProcedure, typeof(string));
				dtEmpty.Columns.Add(TABLE.WorkloadProcess.VbecsProcessId, typeof(int));
			}

			return(dtEmpty);
		}
	}
}

